<?php
/*
Plugin Name: EPC Toolkit
Description: Main toolkit for EPC.
Version: 0.1.8
Author: Vyacheslav
License: GPL2
*/

// Menu
require_once plugin_dir_path(__FILE__) . 'includes/admin-menu.php';

//Pages templates files
require_once plugin_dir_path(__FILE__) . 'templates/main.php';
require_once plugin_dir_path(__FILE__) . 'templates/settings.php';
require_once plugin_dir_path(__FILE__) . 'templates/pages.php';
require_once plugin_dir_path(__FILE__) . 'templates/cleaner.php';
require_once plugin_dir_path(__FILE__) . 'templates/feeder.php';


//utils
require_once plugin_dir_path(__FILE__) . 'utils/pages/pages.php';
require_once plugin_dir_path(__FILE__) . 'utils/pages/shortcodes.php';
require_once plugin_dir_path(__FILE__) . 'utils/cleaner.php';
require_once plugin_dir_path(__FILE__) . 'utils/feeder.php';
require_once plugin_dir_path(__FILE__) . 'utils/general.php';



//css
add_action('admin_enqueue_scripts', 'epc_enqueue_styles');
function epc_enqueue_styles() {
    wp_register_style('epc_styles', plugins_url('assets/css/style.css', __FILE__));
    wp_enqueue_style('epc_styles');
}
define('MY_API_SECRET', 'rmauo366YkmNZWO8g1gKeCxWOK7Xxs87');

//Daily cron
function activate_daily_pages_cron() {    
  if (!wp_next_scheduled('epc_daily_tasks')) {
    wp_schedule_event(time(), 'daily', 'epc_daily_tasks');
  }
  
}
register_activation_hook(__FILE__, 'activate_daily_pages_cron');

function deactivate_daily_pages_cron() {
  $timestamp = wp_next_scheduled('epc_daily_tasks');
  wp_unschedule_event($timestamp, 'epc_daily_tasks');
}
register_deactivation_hook(__FILE__, 'deactivate_daily_pages_cron');

function epc_daily_perform_tasks()
{
  require_once(ABSPATH . "wp-admin" . '/includes/image.php');
  require_once(ABSPATH . "wp-admin" . '/includes/file.php');
  require_once(ABSPATH . "wp-admin" . '/includes/media.php');
  //check new pages
  pages_action();
  //cleaning
  post_delete_action();
}

add_action('epc_daily_tasks', 'epc_daily_perform_tasks');


//Week cron
function activate_weekly_cron() {
  if (!wp_next_scheduled('epc_weekly_tasks')) {
    wp_schedule_event(time(), 'daily', 'epc_weekly_tasks');
  }
  
}
register_activation_hook(__FILE__, 'activate_weekly_cron');
function deactivate_weekly_cron() {
  $timestamp = wp_next_scheduled('epc_weekly_tasks');
  wp_unschedule_event($timestamp, 'epc_weekly_tasks');
}
register_deactivation_hook(__FILE__, 'deactivate_weekly_cron');

function epc_weekly_perform_tasks()
{
  require_once(ABSPATH . "wp-admin" . '/includes/image.php');
  require_once(ABSPATH . "wp-admin" . '/includes/file.php');
  require_once(ABSPATH . "wp-admin" . '/includes/media.php');
  $days_of_week = array(
    'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'
  );
  $current_day_of_week = date_i18n('l');
  $feeds = get_option('gpt_items_value', array());
  foreach ($feeds as $index => $feed) {
    $feeds[$index] = $feed;
    if ($feed['cron_days'] == "Every day"){
      feed_action($feed);
    }
    if ($feed['cron_days'] == $current_day_of_week){
      feed_action($feed);
    } 
  }
}
add_action('epc_weekly_tasks', 'epc_weekly_perform_tasks');



function epc_toolkit_get_version() {
    $plugin_file = __FILE__;
    $plugin_data = get_file_data($plugin_file, array('Version' => 'Version'));
    return $plugin_data['Version'];
}

if (is_admin()) {
    define('GH_REQUEST_URI', 'https://api.github.com/repos/%s/%s/releases');
    define('GHPU_USERNAME', 'epc-wordpress');
    define('GHPU_REPOSITORY', 'toolkit');
    define('GHPU_AUTH_TOKEN', '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');

    include_once plugin_dir_path(__FILE__) . 'utils/update.php';

    $updater = new ToolkitGhPluginUpdater(__FILE__);
    $updater->init();
}