<?php

function cleaner_template() {
    if (!current_user_can('manage_options')) {
        wp_die(__('You do not have sufficient permissions to access this page.'));
    }

    echo '<div class="wrap">';
    echo '<h2>Cleaner</h2>';

    if (isset($_POST['post_delete']) && check_admin_referer('delete_saved')) {
        post_delete_action();
    }
    echo '<form action="options.php" method="post">';
    settings_fields('epc_post_delete_settings');
    do_settings_sections('epc_post_delete_settings');
    echo '<table class="form-table">';
    echo '<tr valign="top">';
    echo '<th scope="row">Excluded images IDs:</th>';
    echo '<td><input type="text" name="epc_post_delete_excluded_images" value="' . esc_attr(get_option('epc_post_delete_excluded_images')) . '" /></td>';
    echo '</tr>';
    echo '<tr valign="top">';
    echo '<th scope="row">Delete unattached images older:</th>';
    echo '<td><input type="text" name="epc_images_days" value="' . esc_attr(get_option('epc_images_days')) . '" /></td>';
    echo '</tr>';
    echo '<tr valign="top">';
    echo '<th scope="row">Enable Cron Task:</th>';
    echo '<td><label><input type="checkbox" name="epc_cron_enabled" ' . checked(get_option('epc_cron_enabled'), "on", false) . ' /> Enable</label></td>';
    echo '</tr>';
    echo '<tr valign="top">';
    echo '<th scope="row">Delete unattached images:</th>';
    echo '<td><label><input type="checkbox" name="epc_delete_images" ' . checked(get_option('epc_delete_images'), "on", false) . ' /> Enable</label></td>';
    echo '</tr>';
    echo '<tr valign="top">';
    echo '<th scope="row">Enable logs:</th>';
    echo '<td><label><input type="checkbox" name="epc_enable_logs" ' . checked(get_option('epc_enable_logs'), "on", false) . ' /> Enable</label></td>';
    echo '</tr>';
    echo '<tr valign="top">';
    echo '<th scope="row">Delete all:</th>';
    echo '<td><label><input type="checkbox" name="delete_all" ' . checked(get_option('delete_all'), "on", false) . ' /> Enable</label></td>';
    echo '</tr>';
    echo '<tr valign="top">';
    echo '<td><label><a class="button button-primary" style="background: #e7a509; border-color: #e7a509;" target="_blank" href="'. WP_PLUGIN_URL . '/epc_cleaner/cleaner.log'.'">Open log file</a></label></td>';
    echo '</tr>';
    echo '</table>';
    submit_button('Save');
    echo '</form>';

    echo '<form action="admin.php?page=cleaner" method="post">';
    wp_nonce_field('delete_saved');
    echo '<input type="hidden" value="true" name="post_delete" />';
    submit_button('Delete Now');
    echo '</form>';

    echo '</div>';
}