<?php

function feeder_template() {
// This function creates the output for the admin page.
// It also checks the value of the $_POST variable to see whether
// there has been a form submission.

// The check_admin_referer is a WordPress function that does some security
// checking and is recommended good practice.

// General check for user permissions.
if (!current_user_can('manage_options'))  {
  wp_die(__('You do not have sufficient pilchards to access this page.'));
}

// Process form submission and update the value if necessary
if (isset($_POST['gpt_rss']) && check_admin_referer('gpt_rss')) {
  // the button has been pressed AND we've passed the security check
  
  // Update the main fields
  $new_value = sanitize_text_field($_POST['gpt_api_key']);
  update_option('gpt_api_key', $new_value);
  $new_value = sanitize_text_field($_POST['gpt_temperature']);
  update_option('gpt_temperature_value', $new_value);
  $new_value = sanitize_text_field($_POST['gpt_max_tokens']);
  update_option('gpt_max_tokens_value', $new_value);
  $new_value = sanitize_text_field($_POST['feed_max_posts']);
  update_option('feed_max_posts_value', $new_value);
  $new_value = sanitize_text_field($_POST['feed_offset']);
  echo(sanitize_text_field($_POST['feed_offset']));
  update_option('feed_offset_value', $new_value);
  $new_value = sanitize_text_field($_POST['gpt_models']);
  update_option('gpt_models_value', $new_value);
  
  // Update the array of items
  $feed_url_values = isset($_POST['feed_url']) ? array_map('sanitize_text_field', $_POST['feed_url']) : array();
  $feed_prompt_values = isset($_POST['feed_prompt']) ? array_map('sanitize_text_field', $_POST['feed_prompt']) : array();
  $title_prompt_values = isset($_POST['title_prompt']) ? array_map('sanitize_text_field', $_POST['title_prompt']) : array();
  $feed_category_values = isset($_POST['feed_category']) ? array_map('sanitize_text_field', $_POST['feed_category']) : array();
  $cron_days_values = isset($_POST['cron_days']) ? array_map('sanitize_text_field', $_POST['cron_days']) : array();
  
  $items = array();
  for ($i = 0; $i < count($feed_url_values); $i++) {
    $feed_url = $feed_url_values[$i];
    $feed_prompt = $feed_prompt_values[$i];
    $title_prompt = $title_prompt_values[$i];
    $feed_category = $feed_category_values[$i];
    $cron_days = $cron_days_values[$i];
    
    // Check if both fields are empty, skip creating new item
    if (empty($feed_url)) {
      continue;
    }
    
    $item = array(
      'feed_url' => $feed_url,
      'feed_prompt' => $feed_prompt,
      'title_prompt' => $title_prompt,
      'feed_category' => $feed_category,
      'cron_days' => $cron_days,
    );
    $items[] = $item;
  }
  
  // Remove empty array elements
  $items = array_values($items);
  
  update_option('gpt_items_value', $items);
}

// Retrieve the stored values
$gpt_api_key = get_option('gpt_api_key');
$gpt_temperature_value = get_option('gpt_temperature_value');
$gpt_max_tokens_value = get_option('gpt_max_tokens_value');
$feed_max_posts_value = get_option('feed_max_posts_value');
$feed_offset_value = get_option('feed_offset_value');
$gpt_models_value = get_option('gpt_models_value');
$items = get_option('gpt_items_value', array());

// Start building the page

echo '<div class="wrap">';

echo '<h2>GPT Feed</h2>';
// Check whether the button has been pressed AND also check the nonce
if (isset($_POST['gpt_rss']) && check_admin_referer('gpt_rss')) {
  // the button has been pressed AND we've passed the security check
  gpt_rss_action();
}

$gpt_models = array(
  'gpt-3.5-turbo', 'gpt-3.5-turbo-1106' , 'gpt-4', 'text-davinci-003'
);

echo '<form action="admin.php?page=feeder" method="post">';

// this is a WordPress security feature - see: https://codex.wordpress.org/WordPress_Nonces
wp_nonce_field('gpt_rss');
echo '<h4>GPT Settings</h4>';
echo '<label for="gpt_api_key">GPT API key:</label>';
echo '<input type="text" id="gpt_api_key" name="gpt_api_key" value="' . esc_attr($gpt_api_key) . '" style="width: 100%;" />';
echo '<p>';
if (empty(esc_attr($gpt_models_value))) {
  echo '<label for="gpt_models">GPT Model:</label>';
  echo '<select id="gpt_models" name="gpt_models">';
  echo '<option value="">Choose GPT Model</option>';
  foreach ($gpt_models as $model) {
    echo '<option value="' . $model . '">' . $model . '</option>';
  }
  echo '</select>';
} else {
  echo '<label for="gpt_models">GPT Model:</label>';
  echo '<select id="gpt_models" name="gpt_models">';
  foreach ($gpt_models as $model) {
    if ($model == esc_attr($gpt_models_value)){
      echo '<option selected value="' . $model . '">' . $model . '</option>';
    }else {
      echo '<option value="' . $model . '">' . $model . '</option>';
    }
  }
  echo '</select>';
}
echo '<label for="gpt_temperature">GPT temperature:</label>';
echo '<input type="text" id="gpt_temperature" name="gpt_temperature" value="' . esc_attr($gpt_temperature_value) . '" />';
echo '<label for="gpt_max_tokens">GPT max_tokens:</label>';
echo '<input type="text" id="gpt_max_tokens" name="gpt_max_tokens" value="' . esc_attr($gpt_max_tokens_value) . '" />';
echo '<label for="feed_max_posts">Read posts in feed:</label>';
echo '<input type="text" id="feed_max_posts" name="feed_max_posts" value="' . esc_attr($feed_max_posts_value) . '" />';
echo '<label for="feed_offset">Offset:</label>';
echo '<input type="text" id="feed_offset" name="feed_offset" value="' . esc_attr($feed_offset_value) . '" />';
echo '</p>';

// Retrieve the categories
$categories = get_categories( array(
  "hide_empty" => 0,
  'orderby' => 'name',
  'order'   => 'ASC'
  ) );
  $days_of_week = array(
    'Every day' , 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'
  );
  
  // Loop through the items array and display fields for each item
  foreach ($items as $index => $item) {
    echo '<div style="background: #bebebe; padding: 10px; border-radius: 10px; margin: 10px 0;">';
    if (empty($item['feed_category'])) {
      echo '<label for="feed_category[]">Category:</label>';
      echo '<select id="feed_category[]" name="feed_category[]">';
      echo '<option value="">Choose category</option>';
      foreach ($categories as $category) {
        echo '<option value="' . $category->term_id . '">' . $category->name . '</option>';
      }
      echo '</select>';
    } else {
      echo '<label for="feed_category[]">Category:</label>';
      echo '<select id="feed_category[]" name="feed_category[]">';
      foreach ($categories as $category) {
        if ($category->term_id == $item['feed_category']){
          echo '<option selected value="' . $category->term_id . '">' . $category->name . '</option>';
        }else {
          echo '<option value="' . $category->term_id . '">' . $category->name . '</option>';
        }
      }
      echo '</select>';
    }
    echo '<p>';
    echo '<label for="feed_url[]">Feed URL:</label>';
    echo '<input type="text" id="feed_url[]" name="feed_url[]" value="' . esc_attr($item['feed_url']) . '" style="width: 100%;" />';
    echo '<label for="title_prompt[]">Title prompt to send to Chat-GPT:</label>';
    echo '<input type="text" id="title_prompt[]" name="title_prompt[]" value="' . esc_attr($item['title_prompt']) . '" style="width: 100%;" />';
    echo '<label for="feed_prompt[]">Prompt to send to Chat-GPT:</label>';
    echo '<input type="text" id="feed_prompt[]" name="feed_prompt[]" value="' . esc_attr($item['feed_prompt']) . '" style="width: 100%;" />';
    echo '<span>Available <b>{LINK}</b> <b>{TITLE}</b></span>';
    if (empty($item['cron_days'])) {
      echo '<label for="cron_days[]">Select Days:</label>';
      echo '<select id="cron_days[]" name="cron_days[]">';
      echo '<option value="">Choose days</option>';
      foreach ($days_of_week as $day) {
        echo '<option value="' . $day . '">' . $day . '</option>';
      }
      echo '</select>';
    } else {
      echo '<label for="cron_days[]">Select Days:</label>';
      echo '<select id="cron_days[]" name="cron_days[]">';
      foreach ($days_of_week as $day) {
        if ($day == $item['cron_days']){
          echo '<option selected value="' . $day . '">' . $day . '</option>';
        }else {
          echo '<option value="' . $day . '">' . $day . '</option>';
        }
      }
      echo '</select>';
    }
    echo '</div>';
  }
  
  // Display fields for adding new items
  echo '<div style="background: #d9d9d9; padding: 10px; border-radius: 10px; margin: 10px 0;">';
  echo '<h4>Add New Feed</h4>';
  echo '<label for="new_feed_category">Category:</label>';
  echo '<select id="new_feed_category" name="feed_category[]">';
  echo '<option value="">Choose category</option>';
  foreach ($categories as $category) {
    echo '<option value="' . $category->term_id . '">' . $category->name . '</option>';
  }
  echo '</select>';
  echo '<p>';
  echo '<label for="new_feed_url">Feed URL:</label>';
  echo '<input type="text" id="new_feed_url" name="feed_url[]" style="width: 100%;" />';
  echo '<label for="new_title_prompt">Title prompt to send to Chat-GPT:</label>';
  echo '<input type="text" id="new_title_prompt" name="title_prompt[]" style="width: 100%;" />';
  echo '<label for="new_feed_prompt">Prompt to send to Chat-GPT:</label>';
  echo '<input type="text" id="new_feed_prompt" name="feed_prompt[]" style="width: 100%;" />';
  echo '<span>Available <b>{LINK}</b> <b>{TITLE}</b></span>';
  echo '<label for="cron_days[]">Select Days:</label>';
  echo '<select id="cron_days[]" name="cron_days[]">';
  echo '<option value="">Choose days</option>';
  foreach ($days_of_week as $day) {
    echo '<option value="' . $day . '">' . $day . '</option>';
  }
  echo '</select>';
  echo '</p>';
  echo '</div>';
  echo '<input type="hidden" value="true" name="gpt_rss" />';
  submit_button('Save');
  echo '</form>';
  
  echo '</div>';
}