<?php

function epc_toolkit_main_page() {
    $cron_disabled = defined('DISABLE_WP_CRON') && DISABLE_WP_CRON;
    $cron_status = $cron_disabled ? 'Disabled' : 'Enabled';
    $cron_class = $cron_disabled ? 'status-disabled' : 'status-enabled';

    $pages_value = get_option('pages_value');
    $is_cleaner_on = (get_option('epc_cron_enabled') === "on");
    $cleaner_class = $is_cleaner_on ? 'status-enabled' : 'status-disabled';

    ?>
    <div class="wrap">
        <h1>EPC Toolkit</h1>
        <div class="main-container">
            <div class="epc-status-card">
                <h2>WP Cron Status
                    <a href="https://wiki.epcnetwork.dev/en/wp-cron" target="_blank" style="text-decoration: none;" title="Learn more about WP Cron">
                        <span class="dashicons dashicons-info-outline"></span>
                    </a>
                </h2>
                <p class="epc-status <?php echo $cron_class; ?>">
                    <?php echo $cron_status; ?>
                </p>
            </div>
            <div class="epc-status-card">
                <h2>Current company</h2>
                <p class="epc-status status-enabled">
                    <?php echo !empty($pages_value) ? $pages_value : 'None'; ?>
                </p>
            </div>
            <div class="epc-status-card">
                <h2>Cleaner</h2>
                <p class="epc-status <?php echo $cleaner_class; ?>">
                    <?php echo $is_cleaner_on ? "On" : "Off"; ?>
                </p>
            </div>
        </div>
    </div>
    <?php
}
