<?php

function pages_template(){
    // This function creates the output for the admin page.
    // It also checks the value of the $_POST variable to see whether
    // there has been a form submission.
    
    // The check_admin_referer is a WordPress function that does some security
    // checking and is recommended good practice.
    
    // General check for user permissions.
    if (!current_user_can('manage_options'))  {
      wp_die(__('You do not have sufficient pilchards to access this page.'));
    }
    
    // Process form submission and update the value if necessary
    if (isset($_POST['submit_action']) && check_admin_referer('epc-pages')) {
      // the button has been pressed AND we've passed the security check
      
      // Update the main fields
      $template_value = sanitize_text_field($_POST['pages_template']);
      update_option('pages_template', $template_value);
      $pages_value = sanitize_text_field($_POST['pages']);
      update_option('pages_value', $pages_value);
      
    }
    
    // Retrieve the stored values
    $pages_template = get_option('pages_template');
    $pages_value = get_option('pages_value');
    
    // Start building the page
    
    echo '<div class="wrap">';
    
    echo '<h2>Service pages settings</h2>';
    // Check whether the button has been pressed AND also check the nonce
    if (isset($_POST['submit_action'])) {
      $action = $_POST['submit_action'];
      if ($action === 'save') {
        page_helper_action();
      }
      elseif ($action === 'get_files') {
        handle_get_files_from_nodejs();
      }
    }
    //Comments: 25.03.2024 wp-devs-team-kitchen talk
    $pages = get_option('epc_pages_array');
    
    echo '<form action="admin.php?page=epc-pages" method="post">';
    
    // this is a WordPress security feature - see: https://codex.wordpress.org/WordPress_Nonces
    wp_nonce_field('epc-pages');
    echo '<h4>Pages Settings</h4>';
    echo '<label for="pages_template">Pages template:</label>';
    echo '<input type="text" id="pages_template" name="pages_template" value="' . esc_attr($pages_template) . '" style="width: 100%;" />';
    echo '<p>';
    if (empty(esc_attr($pages_value))) {
      echo '<label for="pages">Pages:</label>';
      echo '<select id="pages" name="pages">';
      echo '<option value="">Choose pages</option>';
      foreach ($pages as $page) {
        echo '<option value="' . $page . '">' . $page . '</option>';
      }
      echo '</select>';
    } else {
      if ( empty($pages) ){
        echo "Load Pages!";
      } else{
      echo '<label for="pages">Pages:</label>';
      echo '<select id="pages" name="pages">';
      foreach ($pages as $page) {
        if ($page == esc_attr($pages_value)){
          echo '<option selected value="' . $page . '">' . $page . '</option>';
        }else {
          echo '<option value="' . $page . '">' . $page . '</option>';
        }
      }
      echo '</select>';
    }
    }
    echo '</p>';
    echo '<button type="submit" class="epc-button-save" name="submit_action" value="save">Save</button>';
    echo '<button type="submit" class="epc-button-get" name="submit_action" value="get_files">Get Pages from server</button>';
    echo '</form>';
    echo '</div>';
    
    
  }