<?php

function post_delete_action() {
    $cats = get_categories();
    $iteration_limit = 1000;
    $iteration_time_limit = 25;
    $start_time = time();
    $excluded_images = get_option('epc_post_delete_excluded_images');
    if (empty(get_option('epc_images_days'))){
        $images_days = 30;
    } else{
        $images_days = get_option('epc_images_days');
    }
    

    $continue_processing = true;
    $iteration = 0;
    $total_deleted_posts = 0;
    $total_deleted_images = 0;

    $cron_enabled = get_option('epc_cron_enabled');
    $cron_images = get_option('epc_delete_images');
    $enable_logs = get_option('epc_enable_logs');
    $delete_all = get_option('delete_all');

    if ($cron_enabled == "on"){
        while ($iteration < $iteration_limit && $continue_processing) {
            $continue_processing = false;
            $has_posts = false;
            $has_images = false;
    
            $deleted_posts_in_iteration = 0;
            $deleted_img_in_iteration = 0;
    
            foreach ($cats as $cat) {
                $args = array(
                    'post_type'      => 'post',
                    'post_status'    => 'publish',
                    'category_name'  => $cat->slug,
                    'orderby'        => 'date',
                    'order'          => 'ASC',
                    'posts_per_page' => 40,
                );
                $posts = get_posts($args);
    
                $post_count = count($posts);
                $remaining_posts = max(0, $post_count - 20);
    
                foreach ($posts as $index => $post) {
                    $original_title = get_post_meta($post->ID, 'original_title', true);
                    if ($index < $remaining_posts && strtotime($post->post_date) < strtotime('-30 days') && empty($original_title)) {
                        if (has_post_thumbnail($post->ID)) {
                            $attachment_id = get_post_thumbnail_id($post->ID);
                            if (!is_excluded_image($attachment_id, $excluded_images)) {
                                $total_deleted_images++;
                                $deleted_img_in_iteration++;
                                wp_delete_attachment($attachment_id, true);
                            }
                        }
                        $deleted_posts_in_iteration++;
                        $total_deleted_posts++;
                        wp_delete_post($post->ID, true);
                        $has_posts = true;
                    }
                    else {
                        if ($delete_all == "on"){
                            if (has_post_thumbnail($post->ID)) {
                                $attachment_id = get_post_thumbnail_id($post->ID);
                                if (!is_excluded_image($attachment_id, $excluded_images)) {
                                    $total_deleted_images++;
                                    $deleted_img_in_iteration++;
                                    wp_delete_attachment($attachment_id, true);
                                }
                            }
                                wp_delete_post($post->ID, true);
                            
                        }
                    }
                }
    
                if ($has_posts) {
                    $continue_processing = true;
                }
            }
    
            if($cron_images == "on"){
                if ($has_posts) {
                    $args = array(
                        'post_type'   => 'attachment',
                        'numberposts' => -1,
                        'post_status' => null,
                        'post_parent' => 0,
                        'orderby'        => 'date',
                        'order'          => 'ASC',
                        'posts_per_page' => 20,
                    );
                } else {
                    $args = array(
                        'post_type'   => 'attachment',
                        'numberposts' => -1,
                        'post_status' => null,
                        'post_parent' => 0,
                        'orderby'        => 'date',
                        'order'          => 'ASC',
                        'posts_per_page' => 60,
                    );
                }
        
                $unattached_images = get_posts($args);
        
                foreach ($unattached_images as $image) {
                    $attachment_id = $image->ID;
                    if (!is_excluded_image($attachment_id, $excluded_images) && strtotime($image->post_date) < strtotime('-'.$images_days.' days')) {
                        $total_deleted_images++;
                        $deleted_img_in_iteration++;
                        wp_delete_attachment($attachment_id, true);
                        $has_images = true;
                    }
                }
        
                if ($has_images) {
                    $continue_processing = true;
                }
            }
            $current_time = time();
            $elapsed_time = $current_time - $start_time;
            if ($elapsed_time >= $iteration_time_limit) {
                // Next iteration in 1 sec
                wp_schedule_single_event(time() + 1, 'epc_continue_iteration');
                // stop iteration
                return;
            }
    
            set_time_limit($iteration_time_limit);
            if ($enable_logs == "on"){
                epc_write_log("Deleted $deleted_posts_in_iteration posts and $deleted_img_in_iteration images in iteration $iteration.");
            }
    
            $iteration++;
        }
    
        // Logs
        if ($enable_logs == "on"){
            $log_message = "Total: Deleted $total_deleted_posts posts and $total_deleted_images images.";
            epc_write_log($log_message);
        }
    }

    
}

add_action('epc_continue_iteration', 'epc_continue_iteration_handler');

function epc_continue_iteration_handler() {
    // Call post_delete_action() to repeat
    post_delete_action();
}

// hook that function onto our scheduled event:
add_action('epc_weekly_cron', 'post_delete_action');

function is_excluded_image($attachment_id, $excluded_images) {
    $excluded_images = explode(',', $excluded_images);
    $excluded_images = array_map('trim', $excluded_images);
    return in_array($attachment_id, $excluded_images);
}

// Register settings
add_action('admin_init', 'post_delete_register_settings');

function post_delete_register_settings() {
    register_setting('epc_post_delete_settings', 'epc_post_delete_excluded_images');
    register_setting('epc_post_delete_settings', 'epc_images_days');
    register_setting('epc_post_delete_settings', 'epc_cron_enabled');
    register_setting('epc_post_delete_settings', 'epc_delete_images');
    register_setting('epc_post_delete_settings', 'epc_enable_logs');
    register_setting('epc_post_delete_settings', 'delete_all');
}

// Logging function
function epc_write_log($message) {
    $log_file = plugin_dir_path(__FILE__) . '/cleaner.log';
    $formatted_message = '[' . date('Y-m-d H:i:s') . '] ' . $message . "\n";
    file_put_contents($log_file, $formatted_message, FILE_APPEND);
}