<?php

function sendRequest($data, $attempts, $api_key)
{
    if (isset($data['model'])){
      $url = "https://api.openai.com/v1/chat/completions";
      $legacy = false;
      echo "<br>Legacy = false<br>";
    } else{
      $url = "https://api.openai.com/v1/engines/text-davinci-003/completions";
      $legacy = true;
      echo "<br>Legacy = true<br>";
    }
    $ch = curl_init($url);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/json",
        "Authorization: Bearer " . $api_key
    ]);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

    $response = curl_exec($ch);
    echo "<br>Responce: ".$response;
    $httpCode = curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
    echo "<br>httpCode".$httpCode."<br>";

    curl_close($ch);

    if ($httpCode === 200) {
        $responce_new = json_decode($response);
        if ($legacy){
          $rewritten_text = $responce_new->choices[0]->text;
        } else{
          $rewritten_text = $responce_new->choices[0]->message->content;
        }
        if (!empty($rewritten_text)) {
            echo "<br>Att: ".$attempts."<br>";
            $rewritten_text = str_replace('"', '', $rewritten_text);
            echo " ITER";
            $rewritten_text_final = str_replace("Title: ", "", $rewritten_text);
            //echo $rewritten_text."<br>";
            return $rewritten_text_final;
        } else {
            $attempts++;
            if ($attempts < 1) {
                echo "<br>attempts < 3(content empty)<br>";
                return sendRequest($data, $attempts, $api_key);
            } else {
                echo 'Error: Maximum number of attempts reached. 2';
            }
        }
    } else {
        $attempts++;
        if ($attempts < 1) {
            echo "<br>attempts < 3(Not 200)<br>";
            return sendRequest($data, $attempts, $api_key);
        } else {
            echo 'Error: Maximum number of attempts reached. 3';
        }
    }
}

function feed_action($feed){
    if (get_option('gpt_models_value') == "text-davinci-003"){
      $legacy = true;
    } else{
      $legacy = false;
    }
    $curl = curl_init();
    $count = 0;
    $processed = 0;
    // Create cURL request for the feed URL
    curl_setopt($curl, CURLOPT_URL, $feed['feed_url']);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
    $xml_content = curl_exec($curl);
    $httpCode = curl_getinfo($curl, CURLINFO_RESPONSE_CODE);
    echo "HTTP: ".$httpCode;
    
    if ($xml_content === false) {
      // Handle cURL error
      echo 'cURL Error: ' . curl_error($curl);
      return;
    }
    
    // Close cURL session
    curl_close($curl);
    
    // Load the XML content into a SimpleXML object
    $xml = simplexml_load_string($xml_content);
    
    if ($xml === false) {
      // Handle SimpleXML error
      echo 'SimpleXML Error: Cannot parse XML';
      return;
    }
    $offset = intval(get_option('feed_offset_value'));
    foreach ($xml->channel->item as $item) {
      $count++;
      if ($count <= $offset) {
        continue;
      }
      $processed++;
      if ($processed > get_option('feed_max_posts_value')) {
          break;
      } else {
        //check dub
        $args = array(
          'category' => array($feed['feed_category']),
          'post_type'   => 'post',
          'post_status' => 'publish',
          'meta_key'   => 'original_title',
          'meta_value' => strval($item->title),
        );
        
        $existing_posts = get_posts($args);
        
        //HERE
        if (empty($existing_posts)) {
          preg_match('/<img.+src=[\'"](?P<src>.+?)[\'"].*>/i', $item->description, $image);
          if (empty($image['src'])) {
            preg_match('/<img.+src=[\'"](?P<src>.+?)[\'"].*>/i', $item->xpath('//content:encoded')[$count-1], $image);
            if (empty($image['src'])) {
              echo "No image";
              continue;
            } else{
              $img = $image['src'];
            }
            
          } else {
            $img = $image['src'];
          }
          $gpt_prompt = str_replace("{LINK}", "$item->link", $feed['feed_prompt']);
          $gpt_prompt = str_replace("{TITLE}", "$item->title", $gpt_prompt);
          if (empty($feed['title_prompt'])) {
            $final_title = strval($item->title);
          } else {
            $title_prompt = str_replace("{LINK}", "$item->link", $feed['title_prompt']);
            $title_prompt = str_replace("{TITLE}", "$item->title", $title_prompt);
            if($legacy){
              $title_data = array(
                "prompt" => $title_prompt,
                "temperature" => intval(get_option('gpt_temperature_value')),
                "max_tokens" => intval(get_option('gpt_max_tokens_value'))
              );
            } else{
              $title_data = [
                "model" => get_option('gpt_models_value'),
                "messages" => [
                    [
                        "role" => "system",
                        "content" => "You are a helpful assistant."
                    ],
                    [
                        "role" => "user",
                        "content" => $title_prompt
                    ]
                ],
                "temperature" => intval(get_option('gpt_temperature_value')),
                "max_tokens" => intval(get_option('gpt_max_tokens_value'))
            ];
            }
            
            $title = sendRequest($title_data, 0, get_option('gpt_api_key'));
            echo "GPT 1";
            echo "<br>Title: ".$title;
            if (empty($title)) {
              return;
            } else {
              $final_title = $title;
            }
          }
          if($legacy){
            $data = array(
              "prompt" => $gpt_prompt,
              "temperature" => intval(get_option('gpt_temperature_value')),
              "max_tokens" => intval(get_option('gpt_max_tokens_value'))
            );
          } else{
            $data = [
              "model" => get_option('gpt_models_value'),
              "messages" => [
                  [
                      "role" => "system",
                      "content" => "You are a helpful assistant."
                  ],
                  [
                      "role" => "user",
                      "content" => $gpt_prompt." Skip Title, Introduction and Conclusion"
                  ]
              ],
              "temperature" => intval(get_option('gpt_temperature_value')),
              "max_tokens" => intval(get_option('gpt_max_tokens_value'))
          ];
          }
          if (empty($feed['feed_prompt'])) {    
            $final_description =  $item->xpath('//content:encoded')[$count-1]."<br>";
            if (empty($final_description) || strlen($final_description)<50){
              $final_description = $item->description;
            }
            $final_description = preg_replace("/<img[^>]+\>/i", "", $final_description);
          } else {
            //$final_description = "GPT generated description";
            echo "GPT 2";
            $final_description = sendRequest($data, 0, get_option('gpt_api_key'));
            echo "<br>Content:".$final_description;
          }
          $post = array(
            'post_title'    => $final_title,
            'post_content'  => $final_description,
            'post_status'   => 'publish',
            'post_author'   => 1,
            'post_category' => array($feed['feed_category'])
          );
          
          $post_id = wp_insert_post($post);
          
          if ($post_id) {
            $image_id = media_sideload_image($img, $post_id, $final_description, 'id');
            update_post_meta($post_id, 'original_title', strval($item->title));
            if (!is_wp_error($image_id)) {
              set_post_thumbnail($post_id, $image_id);
            } else {
              echo 'Img load Error: ' . $image_id->get_error_message();
              
              wp_delete_post($post_id, true);
            }
          } else {
            echo 'Error in post create';
          }
        }
      }
    }
  }
  
  function gpt_rss_action()
  { 
    echo get_option('gpt_models_value');
    if (get_option('gpt_models_value') == "text-davinci-003"){
      $legacy = true;
    } else{
      $legacy = false;
    }
    
    //get feeds
    $feeds = get_option('gpt_items_value', array());
    foreach ($feeds as $index => $feed) {
      $feeds[$index] = $feed;
      $curl = curl_init();
      $count = 0;
      $processed = 0;
      // Create cURL request for the feed URL
      curl_setopt($curl, CURLOPT_URL, $feed['feed_url']);
      curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
      $xml_content = curl_exec($curl);
      $httpCode = curl_getinfo($curl, CURLINFO_RESPONSE_CODE);
      
      if ($xml_content === false) {
        // Handle cURL error
        echo 'cURL Error: ' . curl_error($curl);
        continue;
      }
      
      // Close cURL session
      curl_close($curl);
      
      // Load the XML content into a SimpleXML object
      $xml = simplexml_load_string($xml_content);
      
      if ($xml === false) {
        // Handle SimpleXML error
        echo 'SimpleXML Error: Cannot parse XML';
        continue;
      }
      $offset = intval(get_option('feed_offset_value'));
      foreach ($xml->channel->item as $item) {
        //print_r($item);
        $count++;
        if ($count <= $offset) {
          continue;
        }
        $processed++;
        if ($processed > get_option('feed_max_posts_value')) {
            break;
        } else {
          //check dub
          $args = array(
            'category' => array($feed['feed_category']),
            'post_type'   => 'post',
            'post_status' => 'publish',
            'meta_key'   => 'original_title',
            'meta_value' => strval($item->title),
          );
          
          
          $existing_posts = get_posts($args);
          
          //HERE
          if (empty($existing_posts)) {
            preg_match('/<img.+src=[\'"](?P<src>.+?)[\'"].*>/i', $item->description, $image);
            if (empty($image['src'])) {
              if (isset($item->xpath('//content:encoded')[$count-1])) {
                $content = $item->xpath('//content:encoded')[$count-1];
                preg_match('/<img.+src=[\'"](?P<src>.+?)[\'"].*>/i', $content, $image);
                } else {
                    continue;
                }
              if (empty($image['src'])) {
                echo "No image";
                continue;
              } else{
                $img = $image['src'];
              }
              
            } else {
              $img = $image['src'];
            }
            $gpt_prompt = str_replace("{LINK}", "$item->link", $feed['feed_prompt']);
            $gpt_prompt = str_replace("{TITLE}", "$item->title", $gpt_prompt);
            if (empty($feed['title_prompt'])) {
              $final_title = strval($item->title);
            } else {
              $title_prompt = str_replace("{LINK}", "$item->link", $feed['title_prompt']);
              $title_prompt = str_replace("{TITLE}", "$item->title", $title_prompt);
              if($legacy){
                $title_data = array(
                  "prompt" => $title_prompt,
                  "temperature" => intval(get_option('gpt_temperature_value')),
                  "max_tokens" => intval(get_option('gpt_max_tokens_value'))
                );
              } else{
                $title_data = [
                  "model" => get_option('gpt_models_value'),
                  "messages" => [
                      [
                          "role" => "system",
                          "content" => "You are a helpful assistant."
                      ],
                      [
                          "role" => "user",
                          "content" => $title_prompt
                      ]
                  ],
                  "temperature" => intval(get_option('gpt_temperature_value')),
                  "max_tokens" => intval(get_option('gpt_max_tokens_value'))
              ];
              }
              
              $title = sendRequest($title_data, 0, get_option('gpt_api_key'));
              echo "<br>GPT 1";
              echo "Title: ".$title;
              if (empty($title)) {
                continue;
              } else {
                $final_title = $title;
              }
            }
            if($legacy){
              $data = array(
                "prompt" => $gpt_prompt,
                "temperature" => intval(get_option('gpt_temperature_value')),
                "max_tokens" => intval(get_option('gpt_max_tokens_value'))
              );
            } else{
              $data = [
                "model" => get_option('gpt_models_value'),
                "messages" => [
                    [
                        "role" => "system",
                        "content" => "You are a helpful assistant."
                    ],
                    [
                        "role" => "user",
                        "content" => $gpt_prompt." Skip Title, Introduction and Conclusion"
                    ]
                ],
                "temperature" => intval(get_option('gpt_temperature_value')),
                "max_tokens" => intval(get_option('gpt_max_tokens_value'))
            ];
            }
            if (empty($feed['feed_prompt'])) {    
              if (isset($item->xpath('//content:encoded')[$count-1])) {
                $final_description =  $item->xpath('//content:encoded')[$count-1]."<br>";
              } else{
                continue;
              }
              if (empty($final_description) || strlen($final_description)<50){
                $final_description = $item->description;
              }
              $final_description = preg_replace("/<img[^>]+\>/i", "", $final_description);
            } else {
              //$final_description = "GPT generated description";
              echo "<br>GPT 2";
              $final_description = sendRequest($data, 0, get_option('gpt_api_key'));
              echo "<br>Content:".$final_description;
            }
            $post = array(
              'post_title'    => $final_title,
              'post_content'  => $final_description,
              'post_status'   => 'publish',
              'post_author'   => 1,
              'post_category' => array($feed['feed_category'])
            );
            
            $post_id = wp_insert_post($post);
            
            if ($post_id) {
              $image_id = media_sideload_image($img, $post_id, $final_description, 'id');
              update_post_meta($post_id, 'original_title', strval($item->title));
              
              if (!is_wp_error($image_id)) {
                set_post_thumbnail($post_id, $image_id);
              } else {
                echo '<br>Img load Error: ' . $image_id->get_error_message();
                
                wp_delete_post($post_id, true);
              }
            } else {
              echo 'Error in post create';
            }
          }
        }
      }
    }
    update_option('gpt_items_value', $feeds);
  }