<?php

function epc_toggle_wp_cron($disable) {
    $wp_config_path = ABSPATH . 'wp-config.php';
    if (!file_exists($wp_config_path) || !is_writable($wp_config_path)) {
        return false;
    }
    $config_content = file_get_contents($wp_config_path);
    if ($disable) {
        if (strpos($config_content, "define('DISABLE_WP_CRON', true);") !== false) {
            return true;
        }
        $config_content = preg_replace("/define\('DISABLE_WP_CRON'.*?\);\n?/i", '', $config_content);
        $config_content = preg_replace('/<\?php/', "<?php\ndefine('DISABLE_WP_CRON', true);", $config_content, 1);
    } else {
        $config_content = preg_replace("/define\('DISABLE_WP_CRON'.*?\);\n?/i", '', $config_content);
    }
    return file_put_contents($wp_config_path, $config_content) !== false;
}
