<?php

function get_files_from_nodejs_endpoint() {
  $headers = array(
    'Authorization: Bearer ' . (defined('MY_API_SECRET') ? MY_API_SECRET : ''),
  );
    $url = 'https://api.pages.epcnetwork.dev/files/public-all';
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    $response = curl_exec($ch);
    curl_close($ch);
    if ($response === false) {
        return array();
    }
    $files = json_decode($response, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        return array();
    }

    $files = array_filter($files, function($file) {
      return $file !== 'img';
    });

    $files = array_map(function($file) {
      return pathinfo($file, PATHINFO_FILENAME);
  }, $files);

    return $files;
}

function delete_all_menu_items($menu_name) {
    $menu = wp_get_nav_menu_object($menu_name);
  
    if (!$menu) {
      echo 'No menu.';
      return;
    }
  
    $menu_items = wp_get_nav_menu_items($menu->term_id);
  
    foreach ($menu_items as $menu_item) {
      wp_delete_post($menu_item->ID, true);
    }
  
  }

  function process_xml_content($xml_file_url) {
    $uploaded_files = array();
    $curl = curl_init($xml_file_url);
    $headers = array(
      'Authorization: Bearer ' . (defined('MY_API_SECRET') ? MY_API_SECRET : ''),
    );
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
    
    $xml_content = curl_exec($curl);
    
    if ($xml_content === false) {
      echo 'Failed to fetch XML file content: ' . curl_error($curl);
      return array();
    }
    $pages_value = get_option('pages_value');

    if ($pages_value == "FIT-FinanceAndInvestingTraffic") {
        $source_url = 'https://api.pages.epcnetwork.dev/files/public/images';
        $plugin_dir = plugin_dir_path(__FILE__) . 'images/';
        if (!file_exists($plugin_dir)) {
            mkdir($plugin_dir, 0755, true);
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $source_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $headers = array(
            'Authorization: Bearer ' . (defined('MY_API_SECRET') ? MY_API_SECRET : ''),
        );
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
      
        $response = curl_exec($ch);
      
        if ($response === false) {
            echo 'Failed to fetch image data.';
            exit;
        }
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
      
        if ($http_code !== 200) {
            echo 'Failed to fetch image data. HTTP code: ' . $http_code;
            exit;
        }
        $image_data = json_decode($response, true);
      
        if (!is_array($image_data)) {
            echo 'Invalid response format';
            exit;
        }
        foreach ($image_data as $image) {
            $filename = $image['filename'];
            $file_url = $image['url'];
            $file_path = $plugin_dir . $filename;
            if (!file_exists($file_path)) {
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $file_url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
                $data = curl_exec($ch);
                curl_close($ch);
            
                if ($data) {
                    file_put_contents($file_path, $data);
                } else {
                    echo "Failed to download: $filename <br>";
                }
            }
        }
    }

    curl_close($curl);
    
    $xml = simplexml_load_string($xml_content);
    
    if ($xml === false) {
      echo 'Failed to parse XML.';
      return array();
    }
    
    $pages_data = array();
    foreach ($xml->pages->page as $page) {
      $title = (string) $page->title;
      $content = (string) $page->htmlData;
      $service_name = (string) $page->service_name;
      $pages_data[] = array(
        'title' => $title,
        'content' => $content,
        'service_name' => $service_name
      );
    }
    
    $last_updated = (string) $xml->last_updated;
    $doubleoptin = (string) $xml->doubleoptin;
    $doubleoptin_footer = (string) $xml->doubleoptin_footer;
    $copyright = (string) $xml->copyright;
    $disclaimer = (string) $xml->disclaimer;
    $shortcode_1 = (string) $xml->shortcode_1;
    $shortcode_2 = (string) $xml->shortcode_2;
    $shortcode_3 = (string) $xml->shortcode_3;
    $disclaimer = (string) $xml->disclaimer;
    
    return array(
      'pages_data' => $pages_data,
      'last_updated' => $last_updated,
      'doubleoptin' => $doubleoptin,
      'doubleoptin_footer' => $doubleoptin_footer,
      'copyright' => $copyright,
      'disclaimer' => $disclaimer,
      'shortcode_1' => $shortcode_1,
      'shortcode_2' => $shortcode_2,
      'shortcode_3' => $shortcode_3,
      'uploaded_files' => $uploaded_files
    );
  }

  function create_pages_from_xml($pages_data, $last_updated, $uploaded_files, $doubleoptin, $doubleoptin_footer, $copyright, $disclaimer, $shortcode_1, $shortcode_2, $shortcode_3) {
    if (empty($pages_data)) {
      echo 'No pages data to process.';
      return;
    }
    $menu_name = 'helper_menu';
    $menu_exists = wp_get_nav_menu_object($menu_name);
    $menu_id = $menu_exists->term_id;
    $current_pages_value = get_option('pages_value');
    $old_pages_value = get_option('old_pages_value');
    
    update_option('doubleoptin_content', $doubleoptin);
    update_option('doubleoptin_content_footer', $doubleoptin_footer);
    update_option('shortcode_1_helper', $shortcode_1);
    update_option('shortcode_2_helper', $shortcode_2);
    update_option('shortcode_3_helper', $shortcode_3);
    if ($old_pages_value != $current_pages_value) {
      // Company has changed, delete all pages created by the plugin
      delete_all_menu_items('helper_menu');
      $all_pages_query = new WP_Query(array(
          'post_type' => 'page',
          'post_status' => 'any',
          'meta_query' => array(
              array(
                  'key' => 'service_name',
                  'compare' => 'EXISTS',
              ),
          ),
      ));
      if ($all_pages_query->have_posts()) {
          while ($all_pages_query->have_posts()) {
              $all_pages_query->the_post();
              wp_delete_post(get_the_ID(), true);
          }
      }
  
      wp_reset_postdata();
  
      // Update the old_pages_value option
      update_option('old_pages_value', $current_pages_value);
    }
    
    $pages_template = get_option('pages_template');
    if (!empty($pages_template)){
      $domainName_first_up_spaces_com = $pages_template.'.com';
      $domainName_first_up_spaces = $pages_template;
    } else{
      $domainName_first_up_spaces_com = get_bloginfo('name').'.com';
      $domainName_first_up_spaces = get_bloginfo('name');
    }
    
    $url = get_site_url();
    $remove_http = '#^http(s)?://#';
    $remove_www  = '/^www\./';
    $replace     = '';
    $new_link    = preg_replace( $remove_http, $replace, $url );
    $domainname_com    = preg_replace( $remove_www, $replace, $new_link );
    $domainname = preg_replace("/\.com/", "", $domainname_com);
    $domainName_first_up_com = preg_replace("/\s+/", "", $domainName_first_up_spaces_com);
    $domainName_first_up = preg_replace("/\s+/", "", $domainName_first_up_spaces);
    $domainname_uppercase_spaces = strtoupper($domainName_first_up_spaces);
    $domainname_uppercase = strtoupper($domainName_first_up);
    $domainname_uppercase_com = $domainname_uppercase.'.COM';
    $words = explode(" ", $domainName_first_up_spaces);
    $domain_acronym = preg_replace('/[^A-Z]/', '', $domainName_first_up_spaces);
    $copyright_new = str_replace('{domain.com}', $domainname_com, $copyright);
    $copyright_new = str_replace('{domain}', $domainname, $copyright_new);
    $copyright_new = str_replace('{domainName_first_up_spaces_com}', $domainName_first_up_spaces_com, $copyright_new);
    $copyright_new = str_replace('{domainName_first_up_spaces}', $domainName_first_up_spaces, $copyright_new);
    $copyright_new = str_replace('{domainName_first_up_com}', $domainName_first_up_com, $copyright_new);
    $copyright_new = str_replace('{domainName_first_up}', $domainName_first_up, $copyright_new);
    $copyright_new = str_replace('{domainname_uppercase}', $domainname_uppercase, $copyright_new);
    $copyright_new = str_replace('{domainname_uppercase_spaces}', $domainname_uppercase_spaces, $copyright_new);
    $copyright_new = str_replace('{domainname_uppercase_com}', $domainname_uppercase_com, $copyright_new);
    $copyright_new = str_replace('{domain_acronym}', $domain_acronym, $copyright_new);

    $disclaimer_new = str_replace('{domain.com}', $domainname_com, $disclaimer);
    $disclaimer_new = str_replace('{domain}', $domainname, $disclaimer_new);
    $disclaimer_new = str_replace('{domainName_first_up_spaces_com}', $domainName_first_up_spaces_com, $disclaimer_new);
    $disclaimer_new = str_replace('{domainName_first_up_spaces}', $domainName_first_up_spaces, $disclaimer_new);
    $disclaimer_new = str_replace('{domainName_first_up_com}', $domainName_first_up_com, $disclaimer_new);
    $disclaimer_new = str_replace('{domainName_first_up}', $domainName_first_up, $disclaimer_new);
    $disclaimer_new = str_replace('{domainname_uppercase}', $domainname_uppercase, $disclaimer_new);
    $disclaimer_new = str_replace('{domainname_uppercase_spaces}', $domainname_uppercase_spaces, $disclaimer_new);
    $disclaimer_new = str_replace('{domainname_uppercase_com}', $domainname_uppercase_com, $disclaimer_new);
    $disclaimer_new = str_replace('{domain_acronym}', $domain_acronym, $disclaimer_new);
    update_option('copyright_helper', $copyright_new);
    update_option('disclaimer_helper', $disclaimer_new);
    
    $file_urls = array();
    $upload_dir = wp_upload_dir();
    
    
    foreach ($uploaded_files as $file_info) {
      $file_urls[basename($file_info['file'])] = $file_info['file'];
      $filename = basename($file_info['file']);
      $file_url = $upload_dir['url'] . '/' . $filename;
      $uploaded_files[$filename]['url'] = $file_url;
    }
    
    foreach ($pages_data as $page_data) {
      $page_title = $page_data['title'];
      $page_service_name = $page_data['service_name'];
      $new_content = str_replace('{domain.com}', $domainname_com, $page_data['content']);
      $new_content = str_replace('{domain}', $domainname, $new_content);
      $new_content = str_replace('{domainName_first_up_spaces_com}', $domainName_first_up_spaces_com, $new_content);
      $new_content = str_replace('{domainName_first_up_spaces}', $domainName_first_up_spaces, $new_content);
      $new_content = str_replace('{domainName_first_up_com}', $domainName_first_up_com, $new_content);
      $new_content = str_replace('{domainName_first_up}', $domainName_first_up, $new_content);
      $new_content = str_replace('{domainname_uppercase}', $domainname_uppercase, $new_content);
      $new_content = str_replace('{domainname_uppercase_spaces}', $domainname_uppercase_spaces, $new_content);
      $new_content = str_replace('{domainname_uppercase_com}', $domainname_uppercase_com, $new_content);
      $new_content = str_replace('{domain_acronym}', $domain_acronym, $new_content);
      foreach ($uploaded_files as $file_name => $file_url) {
        if (!empty($file_url['file'])){
          $variable_name = '{' . $file_url['filename'] . '_url}';
          $new_content = str_replace($variable_name, $file_url['url'], $new_content);
        }
        
      }
      
      $page_query = new WP_Query(array(
        'post_type'      => 'page',
        'post_status'    => 'any',
        'posts_per_page' => 1,
        'meta_query'     => array(
          'relation' => 'AND',
          array(
            'key'     => 'last_updated',
            'compare' => 'EXISTS',
          ),
          array(
            'key'     => 'service_name',
            'value'   => $page_service_name,
            'compare' => '=',
            'type'    => 'CHAR',
        ),
        ),
        //'title'          => $page_title,
      ));
      
      if ($page_query->have_posts()) {
        $page_query->the_post();
        $existing_last_updated = get_post_meta(get_the_ID(), 'last_updated', true);
        $existing_parent_company = get_post_meta(get_the_ID(), 'parent_company', true);
        $existing_last_updated = get_post_meta(get_the_ID(), 'last_updated', true);
        if ($existing_last_updated == $last_updated) {
          $existing_custom_fields = get_post_custom(get_the_ID());
          foreach ($existing_custom_fields as $key => $value) {
          }
        } else {
          $page_data = array(
            'ID'           => get_the_ID(),
            'post_content' => $new_content,
          );
          
          $update_post_result = wp_update_post($page_data);
          
          $update_meta_result = update_post_meta(get_the_ID(), 'last_updated', $last_updated);
        }
      } else {
        $post = array(
          'post_title'   => $page_title,
          'post_content' => $new_content,
          'post_status'  => 'publish',
          'post_author'  => 1,
          'post_type'    => 'page'
        );
        
        $post_id = wp_insert_post($post);
        
        if ($post_id) {
          add_post_meta($post_id, 'last_updated', $last_updated);
          add_post_meta($post_id, 'service_name', $page_service_name);
          if ($page_title != 'Thank you'){
            wp_update_nav_menu_item($menu_id, 0, array(
              'menu-item-title' => $page_title,
              'menu-item-object-id' => $post_id,
              'menu-item-object' => 'page',
              'menu-item-status' => 'publish',
              'menu-item-type' => 'post_type',
            ));
          }
        } else {
          echo 'Failed to create page.';
        }
      }
      
      wp_reset_postdata();
    }
  }

  function page_helper_action(){
    $menu_name = 'helper_menu';
      $menu_exists = wp_get_nav_menu_object($menu_name);
  
      if (!$menu_exists) {
        $menu_id = wp_create_nav_menu($menu_name);
    
        $locations = get_theme_mod('nav_menu_locations');
    
        if (!is_array($locations)) {
            $locations = [];
        }
    
        $locations['helper_menu_location'] = $menu_id;
        set_theme_mod('nav_menu_locations', $locations);
    }    
    $pages_value = get_option('pages_value');
    $pages_template = get_option('pages_template');
    $xml_file_url = 'https://api.pages.epcnetwork.dev/files/public/'.$pages_value.'.xml';
    
    $template = isset($_POST['template']) ? sanitize_text_field($_POST['template']) : '';
    
    $xml_data = process_xml_content($xml_file_url);
    //print_r($xml_data);
    if (!empty($xml_data)) {
      create_pages_from_xml($xml_data['pages_data'], $xml_data['last_updated'], $xml_data['uploaded_files'], $xml_data['doubleoptin'], $xml_data['doubleoptin_footer'], $xml_data['copyright'], $xml_data['disclaimer'], $xml_data['shortcode_1'], $xml_data['shortcode_2'], $xml_data['shortcode_3']);
      echo '<div class="updated"><p>Pages updated successfully.</p></div>';
    } else {
      echo 'No pages data to process.';
    }
    $site_domain = get_site_url();
    $site_domain = preg_replace('#^https?://#', '', $site_domain);
    $plugin_version = epc_toolkit_get_version();
    $data = array(
      'domain'        => $site_domain,
      'pluginVersion' => $plugin_version,
      'companyName'   => $pages_value,
    );
  
      $remote_url = 'https://api.pages.epcnetwork.dev/company/update';
      $headers = array(
        'Content-Type'  => 'application/json',
        'Authorization' => 'Bearer ' . (defined('MY_API_SECRET') ? MY_API_SECRET : ''),
      );    
      $response = wp_remote_post($remote_url,
          array(
          'method'    => 'POST',
          'body'      => wp_json_encode($data),
          'headers'   => $headers,
      ));
      if (is_wp_error($response)) {
        print_r($response);
    } else {
      $response_body = wp_remote_retrieve_body($response);
    }
  }

function handle_get_files_from_nodejs() {
    $files = get_files_from_nodejs_endpoint();

    if (!empty($files)) {
        update_option('epc_pages_array', $files);
        echo '<div class="updated"><p>Files updated successfully.</p></div>';
    } else {
        echo '<div class="error"><p>Failed to retrieve files from Node.js endpoint.</p></div>';
    }
}

function pages_action(){
  $menu_name = 'helper_menu';
  $menu_exists = wp_get_nav_menu_object($menu_name);
  if (!$menu_exists) {
      $menu_id = wp_create_nav_menu($menu_name);
      $locations = get_theme_mod('nav_menu_locations');
      $locations['helper_menu_location'] = $menu_id;
      set_theme_mod('nav_menu_locations', $locations);
  }
  $pages_value = get_option('pages_value');
  $pages_template = get_option('pages_template');
  $xml_file_url = 'https://api.pages.epcnetwork.dev/pages/'.$pages_value.'.xml';
  
  $template = isset($_POST['template']) ? sanitize_text_field($_POST['template']) : '';
  
  $xml_data = process_xml_content($xml_file_url);
  if (!empty($xml_data)) {
    create_pages_from_xml($xml_data['pages_data'], $xml_data['last_updated'], $xml_data['uploaded_files'], $xml_data['doubleoptin'], $xml_data['doubleoptin_footer'], $xml_data['copyright'], $xml_data['disclaimer'], $xml_data['$shortcode_1'], $xml_data['$shortcode_2'], $xml_data['$shortcode_3']);
  } else {
  }
  $site_domain = get_site_url();
  $site_domain = preg_replace('#^https?://#', '', $site_domain);
  $plugin_version = epc_toolkit_get_version();
  $data = array(
    'domain'        => $site_domain,
    'pluginVersion' => $plugin_version,
    'companyName'   => $pages_value,
  );

    $remote_url = 'https://api.pages.epcnetwork.dev/company/update';
    $headers = array(
      'Content-Type'  => 'application/json',
      'Authorization' => 'Bearer ' . (defined('MY_API_SECRET') ? MY_API_SECRET : ''),
    );
    $response = wp_remote_post($remote_url,
        array(
        'method'    => 'POST',
        'body'      => json_encode($data),
        'headers'   => $headers,
    ));
    if (is_wp_error($response)) {
    error_log('Error in epc_feeder_cron_task: ' . $response->get_error_message());
  } else {
    $response_body = wp_remote_retrieve_body($response);
    error_log('epc_feeder_cron_task executed successfully');
  }
}

add_action('rest_api_init', function () {
  register_rest_route('page-helper/v1', '/update-company', array(
      'methods' => 'POST',
      'callback' => 'update_company_handler',
      'permission_callback' => function () {
        $allowed_origins = [
            'https://api.pages.epcnetwork.dev',
        ];

        if (isset($_SERVER['HTTP_ORIGIN']) && in_array($_SERVER['HTTP_ORIGIN'], $allowed_origins)) {
            return true;
        }
        return false;
    },
  ));
});

add_action('rest_pre_serve_request', function ($value) {
  header('Access-Control-Allow-Origin: https://api.pages.epcnetwork.dev');
  header('Access-Control-Allow-Methods: POST');
  header('Access-Control-Allow-Headers: Content-Type');
  header('Access-Control-Allow-Credentials: true');
  return $value;
});

function update_company_handler(WP_REST_Request $request) {
  $params = $request->get_json_params();
  if (isset($params['company'])) {
      update_option('pages_value', sanitize_text_field($params['company']));
      pages_action();
      return new WP_REST_Response('Company updated successfully', 200);
  } else {
      return new WP_REST_Response('Invalid request', 400);
  }
}