<?php

function display_doubleoptin() {
  $doubleoptin = get_option('doubleoptin_content', '');

  if (empty($doubleoptin)) {
      return 'No content available.';
  }

  return '<div class="doubleoptin-content">' . esc_html($doubleoptin) . '</div>';
}
add_shortcode('doubleoptin_header', 'display_doubleoptin');

function display_copyright() {
  $copyright = get_option('copyright_helper', '');

  if (empty($copyright)) {
      return 'No content available.';
  }

  return '<div class="copyright-content">' . wp_kses_post($copyright) . '</div>';
}
add_shortcode('copyright_helper', 'display_copyright');

function display_disclaimer() {
  $disclaimer = get_option('disclaimer_helper', '');

  if (empty($disclaimer)) {
      return 'No content available.';
  }

  return '<div class="disclaimer-content">' . wp_kses_post($disclaimer) . '</div>';
}
add_shortcode('disclaimer_helper', 'display_disclaimer');

function display_shortcode_1() {
  $shortcode_1 = get_option('shortcode_1_helper', '');

  if (empty($shortcode_1)) {
      return 'No content available.';
  }

  return '<div class="shortcode_1-content">' . esc_html($shortcode_1) . '</div>';
}
add_shortcode('shortcode_1_helper', 'display_shortcode_1');

function display_shortcode_2() {
  $shortcode_2 = get_option('shortcode_2_helper', '');

  if (empty($shortcode_2)) {
      return 'No content available.';
  }

  return '<div class="shortcode_2-content">' . esc_html($shortcode_2) . '</div>';
}
add_shortcode('shortcode_2_helper', 'display_shortcode_2');

function display_shortcode_3() {
  $shortcode_3 = get_option('shortcode_3_helper', '');

  if (empty($shortcode_3)) {
      return 'No content available.';
  }

  return '<div class="shortcode_3-content">' . esc_html($shortcode_3) . '</div>';
}
add_shortcode('shortcode_3_helper', 'display_shortcode_3');

function display_doubleoptin_footer() {
  $doubleoptin_footer = get_option('doubleoptin_content_footer', '');

  if (empty($doubleoptin_footer)) {
      return 'No content available.';
  }

  return '<div class="doubleoptin-content">' . esc_html($doubleoptin_footer) . '</div>';
}
add_shortcode('doubleoptin_footer', 'display_doubleoptin_footer');

add_filter( 'wpcf7_form_elements', 'doubleoptin_in_cf7' );

function doubleoptin_in_cf7( $form ) {
  $form = do_shortcode( $form );
  return $form;
}